<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;

    public function City()
    {
        return $this->belongsTo('App\Model\City', 'city_id');
    }

    public function order()
    {
        return $this->hasMany('App\Model\Order');
    }

    public function product()
    {
        return $this->hasMany('App\Model\Product');
    }

    public function offers()
    {
        return $this->hasMany('App\Model\Offer');
    }

    public function Categories()
    {
        return $this->hasMany('App\Model\Category');
    }

    public function comments()
    {
        return $this->hasMany('App\Model\Comment');
    }

    public function payment()
    {
        return $this->hasMany('App\Model\Paid');
    }

    public function Notificationable()
    {
        return $this->morphMany('App\Model\Notificationable', 'notificationable');
    }

}